/*
 * Decompiled with CFR 0.152.
 */
package control;

import control.Button;
import control.MainControl;
import control.MenuControl;
import data.Constants;
import java.io.File;
import java.io.FileFilter;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import view.Fonts;
import view.KeyboardInput;

public class SongChooser {
    private File currentFile;
    private File parentFile;
    private File[] songs;
    private File[] directs;
    private static int spacing = 40;
    private static int topDrawZone = 200;
    private static int botDrawZone = Constants.VIEW_HEIGHT - 100;
    private static int numItems = (botDrawZone - topDrawZone) / spacing;
    private static Button songChooseButt = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 2 / 5, topDrawZone - 100, "Chosen Song: " + Constants.SONG_TO_USE, 0.5f);
    private static Button songHeaderButt = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 5 / 8, topDrawZone - 40, "Songs: ", 0.5f);
    private static Button directHeaderButt = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 5, topDrawZone - 40, "Directories: ", 0.5f);
    private static Button infoButt = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 17 / 54 + (int)(50.0f * Fonts.resolutionScale) + (int)MenuControl.offsetX, Constants.VIEW_HEIGHT - 12 + (int)MenuControl.offsetY, "to select", 0.35f);
    private static Button parButt = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 5, topDrawZone + 10, "Up a Directory", 0.5f);
    private Button[] dirButt;
    private Button[] songButt;
    private boolean inButton;
    private Arrow dirUp;
    private Arrow dirDown;
    private Arrow songUp;
    private Arrow songDown;
    private int scrollSpeed;
    private int origScrollSpeed;
    private static int maxScroll = 75;
    private int dirOffset;
    private int bottDirOffset;
    private int songOffset;
    private int bottSongOffset;
    private long lastSpace;
    private boolean spacePressed;

    public SongChooser() {
        File tmp = new File(".");
        this.currentFile = new File(tmp.getAbsolutePath());
        Constants.SONG_ABSOLUTE_PATH = String.valueOf(this.currentFile.getAbsolutePath()) + File.separator + "IncludedMusic" + File.separator + "00 - Sound Story.mp3";
        this.dirUp = new Arrow(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 3, Constants.VIEW_HEIGHT / 2 - 30, true, 20, 40);
        this.dirDown = new Arrow(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 3, Constants.VIEW_HEIGHT / 2 + 30, false, 20, 40);
        this.songUp = new Arrow(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 5 / 13, Constants.VIEW_HEIGHT / 2 - 30, true, 20, 40);
        this.songDown = new Arrow(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 5 / 13, Constants.VIEW_HEIGHT / 2 + 30, false, 20, 40);
        this.scrollSpeed = 5;
        this.origScrollSpeed = 5;
        this.spacePressed = false;
        this.init();
    }

    public void update() {
        MenuControl.drawKey(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 17 / 54 + (int)(50.0f * Fonts.resolutionScale) + (int)MenuControl.offsetX, Constants.VIEW_HEIGHT - (int)(35.0f * Fonts.resolutionScale) + (int)MenuControl.offsetY, 0.5, "space", KeyboardInput.isKeyActive(57));
        if (parButt.checkCollision(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2)) {
            parButt.highlight();
            if (System.currentTimeMillis() - this.lastSpace > 350L && Keyboard.isKeyDown(57)) {
                parButt.fill();
                parButt.fill();
                parButt.fill();
                this.reInit(this.parentFile);
                this.lastSpace = System.currentTimeMillis();
            }
        }
        songChooseButt.setText("Chosen Song: " + Constants.SONG_TO_USE);
        this.inButton = false;
        this.spacePressed = false;
        this.dirDown.draw(MenuControl.offsetX, MenuControl.offsetY);
        if (this.dirDown.checkCollision(MenuControl.offsetX, MenuControl.offsetY)) {
            this.inButton = true;
            if (Keyboard.isKeyDown(57)) {
                this.dirDown.fill(MenuControl.offsetX, MenuControl.offsetY);
                this.updateDirButts(-this.scrollSpeed);
                this.spacePressed = true;
            }
        }
        this.dirUp.draw(MenuControl.offsetX, MenuControl.offsetY);
        if (this.dirUp.checkCollision(MenuControl.offsetX, MenuControl.offsetY)) {
            this.inButton = true;
            if (Keyboard.isKeyDown(57)) {
                this.dirUp.fill(MenuControl.offsetX, MenuControl.offsetY);
                this.updateDirButts(this.scrollSpeed);
                this.spacePressed = true;
            }
        }
        this.songDown.draw(MenuControl.offsetX, MenuControl.offsetY);
        if (this.songDown.checkCollision(MenuControl.offsetX, MenuControl.offsetY)) {
            this.inButton = true;
            if (Keyboard.isKeyDown(57)) {
                this.songDown.fill(MenuControl.offsetX, MenuControl.offsetY);
                this.updateSongButts(-this.scrollSpeed);
                this.spacePressed = true;
            }
        }
        this.songUp.draw(MenuControl.offsetX, MenuControl.offsetY);
        if (this.songUp.checkCollision(MenuControl.offsetX, MenuControl.offsetY)) {
            this.inButton = true;
            if (Keyboard.isKeyDown(57)) {
                this.songUp.fill(MenuControl.offsetX, MenuControl.offsetY);
                this.updateSongButts(this.scrollSpeed);
                this.spacePressed = true;
            }
        }
        if (this.spacePressed) {
            this.scrollSpeed = (int)((double)this.scrollSpeed * 1.22);
            this.scrollSpeed = Math.min(this.scrollSpeed, maxScroll);
        } else {
            this.scrollSpeed = this.origScrollSpeed;
        }
        this.draw();
        this.checkDirCollision(this.inButton);
        this.checkSongCollision(this.inButton);
    }

    private void updateDirButts(int update) {
        this.dirOffset += update;
        if (update > 0) {
            if (this.dirOffset < 0) {
                Button[] buttonArray = this.dirButt;
                int n = this.dirButt.length;
                int n2 = 0;
                while (n2 < n) {
                    Button b = buttonArray[n2];
                    b.incY(update);
                    ++n2;
                }
            } else {
                this.dirOffset = 0;
                Button[] buttonArray = this.dirButt;
                int n = this.dirButt.length;
                int n3 = 0;
                while (n3 < n) {
                    Button b = buttonArray[n3];
                    b.resetY();
                    ++n3;
                }
            }
        } else if (update < 0) {
            if (this.dirOffset > -this.bottDirOffset) {
                Button[] buttonArray = this.dirButt;
                int n = this.dirButt.length;
                int n4 = 0;
                while (n4 < n) {
                    Button b = buttonArray[n4];
                    b.incY(update);
                    ++n4;
                }
            } else {
                this.dirOffset -= update;
            }
        }
    }

    private void checkDirCollision(boolean inButton) {
        if (!inButton && this.dirButt != null) {
            int i = 0;
            while (i < this.dirButt.length) {
                if (this.dirButt[i].getY() < botDrawZone && this.dirButt[i].getY() > topDrawZone && this.dirButt[i].checkCollision(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2)) {
                    this.dirButt[i].highlight();
                    if (System.currentTimeMillis() - this.lastSpace > 350L && Keyboard.isKeyDown(57)) {
                        this.dirButt[i].fill();
                        this.dirButt[i].fill();
                        this.dirButt[i].fill();
                        this.reInit(this.directs[i]);
                        this.lastSpace = System.currentTimeMillis();
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void updateSongButts(int update) {
        this.songOffset += update;
        if (update > 0) {
            if (this.songOffset < 0) {
                Button[] buttonArray = this.songButt;
                int n = this.songButt.length;
                int n2 = 0;
                while (n2 < n) {
                    Button b = buttonArray[n2];
                    b.incY(update);
                    ++n2;
                }
            } else {
                this.songOffset = 0;
                Button[] buttonArray = this.songButt;
                int n = this.songButt.length;
                int n3 = 0;
                while (n3 < n) {
                    Button b = buttonArray[n3];
                    b.resetY();
                    ++n3;
                }
            }
        } else if (update < 0) {
            if (this.songOffset > -this.bottSongOffset) {
                Button[] buttonArray = this.songButt;
                int n = this.songButt.length;
                int n4 = 0;
                while (n4 < n) {
                    Button b = buttonArray[n4];
                    b.incY(update);
                    ++n4;
                }
            } else {
                this.songOffset -= update;
            }
        }
    }

    private void checkSongCollision(boolean inButton) {
        if (!inButton && this.songButt != null) {
            int i = 0;
            while (i < this.songButt.length) {
                if (this.songButt[i].getY() < botDrawZone && this.songButt[i].getY() > topDrawZone && this.songButt[i].checkCollision(Constants.VIEW_WIDTH / 2, Constants.VIEW_HEIGHT / 2)) {
                    this.songButt[i].highlight();
                    if (System.currentTimeMillis() - this.lastSpace > 350L && Keyboard.isKeyDown(57)) {
                        this.songButt[i].fill();
                        this.songButt[i].fill();
                        this.songButt[i].fill();
                        Constants.SONG_ABSOLUTE_PATH = this.songs[i].getAbsolutePath();
                        if (Constants.SONG_ABSOLUTE_PATH.contains(File.separator)) {
                            Constants.SONG_TO_USE = Constants.SONG_ABSOLUTE_PATH.substring(Constants.SONG_ABSOLUTE_PATH.lastIndexOf(File.separator) + 1, Constants.SONG_ABSOLUTE_PATH.length());
                        }
                        MainControl.scoreControl.reset();
                        this.lastSpace = System.currentTimeMillis();
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void draw() {
        Button b;
        int n;
        int n2;
        Button[] buttonArray;
        infoButt.draw();
        parButt.draw();
        songHeaderButt.draw();
        songChooseButt.draw();
        directHeaderButt.draw();
        if (this.dirButt != null) {
            buttonArray = this.dirButt;
            n2 = this.dirButt.length;
            n = 0;
            while (n < n2) {
                b = buttonArray[n];
                if (b.getY() < botDrawZone && b.getY() > topDrawZone + 30) {
                    b.draw();
                }
                ++n;
            }
        }
        if (this.songButt != null) {
            buttonArray = this.songButt;
            n2 = this.songButt.length;
            n = 0;
            while (n < n2) {
                b = buttonArray[n];
                if (b.getY() < botDrawZone && b.getY() > topDrawZone) {
                    b.draw();
                }
                ++n;
            }
        }
    }

    private void init() {
        int i;
        this.parentFile = this.currentFile.getParentFile();
        this.songs = this.currentFile.listFiles(new Mp3Filter());
        if (this.songs != null) {
            this.bottSongOffset = (this.songs.length - numItems) * spacing;
            this.songButt = new Button[this.songs.length];
            i = 0;
            while (i < this.songs.length) {
                this.songButt[i] = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH * 5 / 8, topDrawZone + 10 + i * spacing, this.songs[i].getName(), 0.5f);
                ++i;
            }
        } else {
            this.songButt = null;
        }
        this.directs = this.currentFile.listFiles(new dirFilter());
        if (this.directs != null) {
            this.bottDirOffset = (this.directs.length - numItems) * spacing;
            this.dirButt = new Button[this.directs.length];
            i = 0;
            while (i < this.directs.length) {
                this.dirButt[i] = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 5, topDrawZone + 50 + i * spacing, this.directs[i].getName(), 0.5f);
                ++i;
            }
        } else {
            this.dirButt = null;
        }
    }

    private void reInit(File parent) {
        this.dirOffset = 0;
        this.songOffset = 0;
        if (parent != null) {
            this.currentFile = parent;
            this.init();
        } else {
            this.songButt = null;
            this.currentFile = null;
            this.directs = File.listRoots();
            this.bottDirOffset = (this.directs.length - numItems) * spacing;
            this.dirButt = new Button[this.directs.length];
            int i = 0;
            while (i < this.directs.length) {
                this.dirButt[i] = new Button(Constants.VIEW_WIDTH + Constants.VIEW_WIDTH / 5, topDrawZone + 50 + i * spacing, this.directs[i].getAbsolutePath(), 0.5f);
                ++i;
            }
        }
    }

    private class Arrow {
        private int xLoc;
        private int yLoc;
        private boolean up;
        private int width;
        private int height;

        public Arrow(int xLoc, int yLoc, boolean up, int width, int height) {
            this.xLoc = xLoc;
            this.yLoc = yLoc;
            this.up = up;
            this.width = width;
            this.height = height;
        }

        public void draw(float offsetX, float offsetY) {
            GL11.glPushAttrib(1048575);
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
            if (this.up) {
                GL11.glBegin(2);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX, (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX + (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glEnd();
            } else {
                GL11.glBegin(2);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX, (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX + (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glEnd();
            }
            GL11.glPopAttrib();
        }

        public void fill(float offsetX, float offsetY) {
            GL11.glPushAttrib(1048575);
            GL11.glColor3f(1.0f, 1.0f, 1.0f);
            if (this.up) {
                GL11.glBegin(9);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX, (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX + (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY);
                GL11.glEnd();
            } else {
                GL11.glBegin(9);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX + (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glVertex2d((float)this.xLoc + offsetX, (float)this.yLoc + offsetY);
                GL11.glVertex2d((float)this.xLoc + offsetX - (float)(this.width / 2), (float)this.yLoc + offsetY - (float)this.height);
                GL11.glEnd();
            }
            GL11.glPopAttrib();
        }

        public boolean checkCollision(float offsetX, float offsetY) {
            return (float)this.xLoc + offsetX - (float)(this.width / 2) <= (float)(Constants.VIEW_WIDTH / 2) && (int)((float)this.xLoc + offsetX + (float)(this.width / 2)) >= Constants.VIEW_WIDTH / 2 && (float)this.yLoc + offsetY - (float)this.height <= (float)(Constants.VIEW_HEIGHT / 2) && (float)this.yLoc + offsetY >= (float)(Constants.VIEW_HEIGHT / 2);
        }
    }

    private class Mp3Filter
    implements FileFilter {
        private Mp3Filter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().endsWith(".mp3");
        }
    }

    private class dirFilter
    implements FileFilter {
        private dirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && !f.isHidden();
        }
    }
}

